/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.uddi;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIBusinessEntity;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.table.AbstractTableModel;

public class VWConfigUDDIListTableModel
extends AbstractTableModel {
    public static final int COLUMN_COUNT = 3;
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_INQUIRY_URL = 1;
    public static final int COLUMN_PUBLISH_URL = 2;
    protected JDialog m_parentDialog = null;
    protected String m_dialogTitle = null;
    private Vector m_rowData = null;
    private boolean m_bHasChanged = false;

    public VWConfigUDDIListTableModel(JDialog parentDialog, VWUDDIRegistry[] vwUDDIRegistrylist) {
        try {
            this.m_parentDialog = parentDialog;
            this.m_rowData = new Vector();
            if (vwUDDIRegistrylist != null) {
                for (int i = 0; i < vwUDDIRegistrylist.length; ++i) {
                    this.m_rowData.add(vwUDDIRegistrylist[i]);
                }
            }
            this.m_dialogTitle = VWIDMBaseFactory.instance().getVWString(4).toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWUDDIRegistry[] getUDDIRegistries() {
        Object[] theList = new VWUDDIRegistry[this.m_rowData.size()];
        this.m_rowData.copyInto(theList);
        return theList;
    }

    public void addRow() {
        try {
            if (this.m_rowData == null) {
                this.m_rowData = new Vector();
            }
            this.m_rowData.addElement(new VWUDDIRegistry());
            int nRow = this.m_rowData.size() - 1;
            this.fireTableRowsInserted(nRow, nRow);
            this.m_bHasChanged = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeRow(int nRow) {
        try {
            if (this.m_rowData == null || nRow < 0 || nRow >= this.m_rowData.size()) {
                return;
            }
            VWUDDIRegistry rowItem = (VWUDDIRegistry)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                VWUDDIBusinessEntity[] businessList;
                if (rowItem.isPublishable() && (businessList = rowItem.getVWBusinessEntities()) != null && businessList.length > 0) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.RemovePublishURLWarning.toString(businessList[0].getNameString(0)), VWResource.ErrorMessage, 1);
                    return;
                }
                this.m_rowData.removeElementAt(nRow);
                this.fireTableRowsDeleted(nRow, nRow);
                this.m_bHasChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void validateRow(int nRow) {
        try {
            if (this.m_rowData == null) {
                return;
            }
            String msg = null;
            VWUDDIRegistry rowItem = (VWUDDIRegistry)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                msg = this.checkDuplicateName(rowItem.getName(), nRow);
                if (msg != null && msg.length() > 0) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, msg, this.m_dialogTitle, 1);
                    return;
                }
                msg = rowItem.validateUDDI();
                if (msg != null && msg.length() > 0) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.InvalidUDDIRegistry.toString(rowItem.getName(), msg, String.valueOf(nRow + 1)), this.m_dialogTitle, 3);
                } else {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.ValidationIsSuccess, this.m_dialogTitle, 2);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public boolean verifyUDDIRegistries() {
        boolean bSuccess = true;
        try {
            if (this.m_rowData != null) {
                int rowCount = this.m_rowData.size();
                for (int i = rowCount - 1; i >= 0; --i) {
                    VWUDDIRegistry rowItem = (VWUDDIRegistry)this.m_rowData.elementAt(i);
                    String msg = null;
                    String uddiName = rowItem.getName();
                    if (uddiName == null || uddiName.length() < 1) {
                        msg = VWResource.s_missingUDDIRegName.toString(String.valueOf(i + 1));
                        VWMessageDialog.showOptionDialog(this.m_parentDialog, msg, this.m_dialogTitle, 1);
                        bSuccess = false;
                        continue;
                    }
                    String inquiryURL = rowItem.getInquiryURL();
                    if (inquiryURL == null || inquiryURL.length() < 1) {
                        msg = VWResource.MissingUDDIRegInquiryURL.toString(String.valueOf(i + 1));
                        VWMessageDialog.showOptionDialog(this.m_parentDialog, msg, this.m_dialogTitle, 1);
                        bSuccess = false;
                        continue;
                    }
                    msg = this.checkDuplicateName(uddiName, i);
                    if (msg != null && msg.length() > 0) {
                        VWMessageDialog.showOptionDialog(this.m_parentDialog, msg, this.m_dialogTitle, 1);
                        bSuccess = false;
                        continue;
                    }
                    msg = rowItem.validateUDDI();
                    if (msg == null || msg.length() <= 0) continue;
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.InvalidUDDIRegistry.toString(rowItem.getName(), msg, String.valueOf(i + 1)), this.m_dialogTitle, 1);
                    bSuccess = false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            bSuccess = false;
        }
        return bSuccess;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumn) {
        switch (nColumn) {
            case 0: {
                return VWResource.Name;
            }
            case 2: {
                return VWResource.PublishURL;
            }
            case 1: {
                return VWResource.InquiryURL;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return null;
            }
            VWUDDIRegistry oUDDIRegistry = (VWUDDIRegistry)this.m_rowData.elementAt(nRowIndex);
            if (oUDDIRegistry == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return oUDDIRegistry.getName();
                }
                case 2: {
                    String publishedURL = oUDDIRegistry.getPublishURL();
                    if (publishedURL == null) {
                        publishedURL = "";
                    }
                    return publishedURL;
                }
                case 1: {
                    String inquiryURL = oUDDIRegistry.getInquiryURL();
                    if (inquiryURL == null) {
                        inquiryURL = "";
                    }
                    return inquiryURL;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        return true;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return;
            }
            VWUDDIRegistry oUDDIRegistry = (VWUDDIRegistry)this.m_rowData.elementAt(nRowIndex);
            if (oUDDIRegistry == null) {
                return;
            }
            switch (nColumnIndex) {
                case 0: {
                    oUDDIRegistry.setName((String)aValue);
                    this.m_bHasChanged = true;
                    break;
                }
                case 2: {
                    VWUDDIRegistry uddiReg;
                    VWUDDIBusinessEntity[] businessList;
                    boolean bCanModify = true;
                    String publishURL = (String)aValue;
                    if ((publishURL == null || publishURL.length() < 1) && (businessList = (uddiReg = (VWUDDIRegistry)this.m_rowData.elementAt(nRowIndex)).getVWBusinessEntities()) != null && businessList.length > 0) {
                        VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.RemovePublishURLWarning.toString(businessList[0].getNameString(0)), VWResource.ErrorMessage, 1);
                        bCanModify = false;
                    }
                    if (!bCanModify) break;
                    oUDDIRegistry.setPublishURL(publishURL);
                    this.m_bHasChanged = true;
                    break;
                }
                case 1: {
                    oUDDIRegistry.setInquiryURL((String)aValue);
                    this.m_bHasChanged = true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        this.m_parentDialog = null;
        this.m_dialogTitle = null;
    }

    private String checkDuplicateName(String uddiName, int row) {
        String msg = null;
        int rowCount = this.m_rowData.size();
        for (int i = 0; i < rowCount; ++i) {
            VWUDDIRegistry uddiReg;
            String urName;
            if (i == row || (urName = (uddiReg = (VWUDDIRegistry)this.m_rowData.elementAt(i)).getName()) == null || uddiName.compareTo(urName) != 0) continue;
            msg = VWResource.DuplicatedUDDIRegistryName.toString(uddiName, String.valueOf(i + 1), String.valueOf(row + 1));
            break;
        }
        return msg;
    }
}

